/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.features;

import com.mojang.serialization.Codec;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.features.BlockStripeFeatureConfig;
import com.ordana.spelunkery.features.util.FastNoiseLite;
import com.ordana.spelunkery.features.util.StoneEntry;
import com.ordana.spelunkery.features.util.StonePattern;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BlockStripeFeature
extends Feature<BlockStripeFeatureConfig> {
    public BlockStripeFeature(Codec<BlockStripeFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStripeFeatureConfig> context) {
        if (CommonConfigs.STONE_STRIPE_FEATURES.get().booleanValue()) {
            BlockStripeFeatureConfig config = (BlockStripeFeatureConfig)context.m_159778_();
            RandomSource random = context.m_225041_();
            BlockPos originPos = context.m_159777_();
            WorldGenLevel worldGenLevel = context.m_159774_();
            ChunkGenerator chunkGenerator = context.m_159775_();
            ChunkAccess cachedChunk = worldGenLevel.m_46865_(originPos);
            FastNoiseLite cellNoise = new FastNoiseLite();
            cellNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
            cellNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.CellValue);
            cellNoise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
            cellNoise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
            cellNoise.SetFrequency(0.01f);
            cellNoise.SetFractalOctaves(1);
            FastNoiseLite cellBufferNoise = new FastNoiseLite();
            cellBufferNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
            cellBufferNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.Distance2Div);
            cellBufferNoise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
            cellBufferNoise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
            cellBufferNoise.SetFrequency(0.01f);
            cellBufferNoise.SetFractalOctaves(1);
            FastNoiseLite noise = new FastNoiseLite();
            noise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
            noise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
            noise.SetFrequency(0.03f);
            noise.SetDomainWarpAmp(1.5f);
            FastNoiseLite.Vector3 domainWarpedVector = new FastNoiseLite.Vector3(0.0, 0.0, 0.0);
            noise.SetFractalOctaves(1);
            int getX = originPos.m_123341_() & 0xFFFFFFF0;
            int getZ = originPos.m_123343_() & 0xFFFFFFF0;
            for (int x = getX; x < getX + 16; ++x) {
                for (int z = getZ; z < getZ + 16; ++z) {
                    int heightmap = worldGenLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                    for (int y = chunkGenerator.m_142062_(); y < heightmap - config.surfaceOffset; ++y) {
                        Holder biome;
                        BlockPos currentPos = new BlockPos(x, y, z);
                        BlockState currentState = cachedChunk.m_8055_(currentPos);
                        boolean isTarget1 = currentState.m_204341_(config.firstTarget);
                        boolean isTarget2 = false;
                        if (config.secondTarget != null && config.secondTargetPlacer != null) {
                            boolean bl = isTarget2 = config.useSecondTarget && currentState.m_204341_(config.secondTarget);
                        }
                        if (!isTarget1 && !isTarget2) continue;
                        domainWarpedVector.x = x;
                        domainWarpedVector.y = y;
                        domainWarpedVector.z = z;
                        noise.DomainWarp(domainWarpedVector);
                        float cellValue = cellNoise.GetNoise(domainWarpedVector.x, domainWarpedVector.y, domainWarpedVector.z);
                        cellValue = cellValue * 0.5f + 0.5f;
                        int stoneIndex = Mth.m_14143_((float)(cellValue * (float)config.firstTargetPlacer.size()));
                        float seed = cellValue * 1000000.0f;
                        Random patchRandom = new Random((long)seed);
                        boolean isBlankPatch = patchRandom.nextFloat() < config.blankPatchChance || (double)cellBufferNoise.GetNoise(domainWarpedVector.x, domainWarpedVector.y, domainWarpedVector.z) > -0.1;
                        boolean passesBiomeFilter = true;
                        if (config.biomes != null && config.useBiomeFilter && !config.biomes.m_203333_(biome = worldGenLevel.m_204166_(currentPos))) {
                            passesBiomeFilter = false;
                        }
                        if (!passesBiomeFilter || isBlankPatch || config.useHeightFilter && y <= cachedChunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z) - config.bottomOffset) continue;
                        List<StoneEntry> patternList = null;
                        if (isTarget1) {
                            patternList = config.firstTargetPlacer;
                        } else if (isTarget2) {
                            patternList = config.secondTargetPlacer;
                        }
                        if (patternList == null) continue;
                        StoneEntry stoneEntry = patternList.get(stoneIndex);
                        StonePattern stonePattern = stoneEntry.getStonePattern();
                        if (stonePattern.shouldPlacePrimaryStone(currentPos)) {
                            worldGenLevel.m_7731_(currentPos, stoneEntry.getPrimaryStoneState(worldGenLevel, currentPos), 2);
                            continue;
                        }
                        if (!stonePattern.shouldPlaceSecondaryStone(currentPos)) continue;
                        worldGenLevel.m_7731_(currentPos, stoneEntry.getSecondaryStoneState(worldGenLevel, currentPos), 2);
                    }
                }
            }
        }
        return false;
    }
}

